# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def velvet_phoenix_rising(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early rounds: unconditional cooperation
    if current_round <= 3:
        return "C"
    
    # Middle rounds: modified Tit-for-Tat
    if 4 <= current_round <= 7:
        if len(opp_history) >= 2 and ("D" in opp_history[-2:]):
            return "D"
        else:
            return "C"
    
    # Late rounds: analyze opponent's code for defection patterns
    if current_round >= 8:
        # Check for hardcoded defection patterns
        if ("return 'D'" in opponent_program_code and 
            ("round >= 8" in opponent_program_code or 
             "current_round == 10" in opponent_program_code or 
             "current_round == 9" in opponent_program_code)):
            return "D"
        # Final-round defection bias
        if current_round == 10:
            return "D"
        # Default to Tit-for-Tat if no clear pattern
        if opp_history and opp_history[-1] == "D":
            return "D"
        else:
            return "C"
    
    # Fallback (shouldn't be reached)
    return "C"